<?php
require_once __DIR__.'/../includes/db.php';
require_once __DIR__.'/../includes/auth.php';
require_once __DIR__.'/../includes/helpers.php';
require_login();
$page_title = "Transactions";

$st = $pdo->prepare("
  SELECT id, kind, amount_cents, balance_after_cents, reference, note, counterparty_acct,
         validation_status, created_at
  FROM transactions
  WHERE user_id = :id
  ORDER BY id DESC
  LIMIT 200
");
$st->execute([':id'=>$_SESSION['uid']]);
$rows = $st->fetchAll();


include __DIR__.'/../includes/header.php';
?>


<div class="row g-4">
  <div class="col-md-9">

<div class="card shadow-sm">
  <div class="card-body">
    <div class="d-flex justify-content-between align-items-center mb-3">
      <h5 class="card-title mb-0">Your Transactions</h5>
      <a href="dashboard.php" class="btn btn-sm btn-outline-secondary">← Back to dashboard</a>
    </div>

    <div class="table-responsive">
      <table class="table align-middle">
        <thead class="table-light">
          <tr>
            <th>Date</th>
            <th>Type</th>
            <th>Amount (₦)</th>
            <th>Balance After (₦)</th>
            <th>Counterparty</th>
            <th>Reference</th>
            <th>Note</th>
          </tr>
        </thead>
        <tbody>
        <?php foreach ($rows as $r): ?>
  <tr>
    <td class="text-nowrap"><?= sanitize($r['created_at']) ?></td>
    <td>
      <?php if ($r['kind'] === 'credit'): ?>
        <span class="badge text-bg-success">credit</span>
      <?php else: ?>
        <span class="badge text-bg-danger">debit</span>
      <?php endif; ?>
    </td>
    <td class="<?= $r['kind']==='credit' ? 'text-success' : 'text-danger' ?>">
      <?= number_format($r['amount_cents']/100,2) ?>
    </td>
    <td><?= number_format($r['balance_after_cents']/100,2) ?></td>
    <td class="text-nowrap"><?= sanitize($r['counterparty_acct']) ?></td>
    <td class="text-monospace"><?= sanitize($r['reference']) ?></td>
    <td><?= sanitize($r['note']) ?></td>
  </tr>

  <?php if ($r['kind'] === 'credit' && ($r['validation_status'] ?? '') === 'pending'): ?>
    <tr>
      <td colspan="7" class="bg-light text-center">
        <form action="validate_payment.php" method="POST" class="d-inline-flex gap-2 align-items-center">
          <input type="hidden" name="transaction_id" value="<?= (int)$r['id'] ?>">
          <input type="text" name="validation_code" placeholder="Enter validation code" required class="form-control form-control-sm" style="width:160px;">
          <button type="submit" name="action" value="validate" class="btn btn-success btn-sm">Validate</button>
          <button type="submit" name="action" value="reject" class="btn btn-outline-danger btn-sm">Reject</button>
        </form>
      </td>
    </tr>
  <?php elseif ($r['kind'] === 'credit' && ($r['validation_status'] ?? '') === 'validated'): ?>
    <tr>
      <td colspan="7" class="text-center text-success small">✅ Payment Validated</td>
    </tr>
  <?php elseif ($r['kind'] === 'credit' && ($r['validation_status'] ?? '') === 'rejected'): ?>
    <tr>
      <td colspan="7" class="text-center text-danger small">❌ Payment Rejected</td>
    </tr>
  <?php endif; ?>
<?php endforeach; ?>

        </tbody>
      </table>
    </div>
  </div>
</div>

<?php include __DIR__.'/../includes/footer.php'; ?>
