<?php
// DEV ONLY: use to seed balance locally. Remove before deploying!
require_once __DIR__.'/../includes/db.php';
require_once __DIR__.'/../includes/auth.php';
require_once __DIR__.'/../includes/helpers.php';
require_login();

$err = $ok = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $amt = (float)($_POST['amount'] ?? 0);
  if ($amt <= 0) {
    $err = 'Enter a positive amount';
  } else {
    $cents = (int)round($amt * 100);
    $upd = $pdo->prepare("UPDATE users SET balance_cents = balance_cents + :c WHERE id = :id");
    $upd->execute([':c'=>$cents, ':id'=>$_SESSION['uid']]);
    $ok = "Added ₦" . number_format($amt, 2) . " to your balance.";
  }
}
?>
<!doctype html>
<html>
  <body style="font-family:system-ui;max-width:700px;margin:40px auto;">
    <h2>Top up (DEV)</h2>
    <?php if($err): ?><div style="background:#ffe6e6;border:1px solid #f99;padding:10px;border-radius:8px;"><?=sanitize($err)?></div><?php endif; ?>
    <?php if($ok): ?><div style="background:#e8fff0;border:1px solid #8ad29b;padding:10px;border-radius:8px;"><?=sanitize($ok)?></div><?php endif; ?>
    <form method="post" style="display:grid;gap:10px;max-width:320px;">
      <input type="number" step="0.01" min="0.01" name="amount" placeholder="e.g. 5000" required>
      <button style="padding:10px 14px;border-radius:8px;border:1px solid #ddd;background:#111;color:#fff;">Add funds</button>
    </form>
    <p style="margin-top:12px;"><a href="dashboard.php">← Back to dashboard</a></p>
  </body>
</html>
