<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Hero Section</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

  <style>
    body {
      margin: 0;
      padding: 0;
      font-family: 'Inter', sans-serif;
      background-color: #000;
    }



.hero-section {
  width: 100%;
  min-height: 80vh;              /* reduced from 100vh */
  background: url('pobo.png') no-repeat;
  background-size: cover;
  background-position: center 30%;
  display: flex;
  align-items: center;
  padding: 120px 60px 80px;
  color: white;
  position: relative;
  margin-top:0px;
}


    .hero-content {
      max-width: 520px;
    }

    .hero-content h1 {
      font-size: 2.8rem;
      font-weight: 700;
      line-height: 1.2;
    }

    .hero-content p {
      font-size: 1rem;
      margin-top:0;
      line-height: 1.6;
      opacity: .9;
    }

    .buttons {
      margin-top: 25px;
    }

    .btn {
      padding: 12px 26px;
      border-radius: 8px;
      font-size: 1rem;
      cursor: pointer;
      border: none;
      margin-right: 10px;
    }

    .btn-primary {
      background: #3B82F6;
      color: white;
    }

    .btn-outline {
      background: transparent;
      border: 1px solid rgba(255,255,255,.6);
      margin-left:158px;
      color: white;
    }
    
    .btn-outlined {
      background: transparent;
      border: 1px solid rgba(255,255,255,.6);
      color: white;
    }
    
    
    .mini-info {
  background: #000;   /* deep dark background */
  padding: 80px 20px;
  text-align: center;
  color: #fff;
  border-top: 1px solid rgba(255, 255, 255, 0.05);
}

.mini-info h2 {
  font-size: 2rem;
  font-weight: 700;
  margin-bottom: 15px;
}

.mini-info p {
  max-width: 650px;
  margin: 0 auto;
  font-size: 1rem;
  line-height: 1.6;
  color: #cfd2dc;
}




@media (max-width: 768px) {
  .hero-section {
    background-image: url('pobo2.png');
    background-position: center top;
    min-height: 100vh;
    padding: 100px 20px 60px;
  }
}

}

/* NAVBAR */
.navbar {
  position: absolute;
  top: 0;              /* ✅ REQUIRED */
  left: 0;
  width: 100%;
  z-index: 1000;
  margin-top: 59px;       /* ✅ REMOVE GAP */
  
  margin-left: 12px;
}


.nav-inner {
  max-width: 1200px;
  margin: 0 auto;
  padding: 20px 40px;
  display: flex;
  align-items: center;
  justify-content: space-between;
}

.logo {
  font-weight: 700;
  font-size: 1.2rem;
  color: white;
}

.nav-links a {
  margin-left: 25px;
  text-decoration: none;
  color: rgba(255,255,255,0.9);
  font-size: 0.95rem;
}

.nav-links a:hover {
  color: #fff;
}

/* HERO FIX (important) */
.hero-section {
}

@media (max-width: 768px) {
  .nav-links {
    display: none; /* hide links for now */
  }

  .nav-inner {
    padding: 16px 20px;
  }
}

.navbar .nav-link {
  color: #fff !important;
  opacity: .85;
}

.navbar .nav-link:hover {
  opacity: 1;
}



    /* Custom CSS to match the image colors precisely */
    .section-dark-bg {
        background-color: #262152; /* Approximate deep indigo/purple */
        color: white; /* Ensure all text is white */
        padding: 60px 0; /* Vertical padding for the section */
    }
    .card-dark-bg {
        background-color: #342D6B; /* Slightly lighter shade for the cards */
        color: white; /* Text in cards remains white */
        padding: 30px;
        border-radius: 8px;
        height: 100%; /* Ensures all cards are the same height */
    }
    .card-dark-bg h3 {
        margin-top: 15px;
        font-weight: 700;
    }
    .icon-box {
        display: inline-block;
        padding: 15px;
        border-radius: 50%; /* Makes the icon container circular */
        background-color: white; /* White circle background */
        color: #342D6B; /* Icon color matching card background */
        font-size: 24px;
        margin-bottom: 10px;
    }
    
    /* ... (KEEP all previous styles for section-dark-bg, card-dark-bg, and icon-box) ... */

    /* Custom CSS for the new Light Section */
    .section-light-bg {
        background-color: #f8f9fa; /* Very light gray/off-white background */
        color: #212529; /* Dark text color (standard Bootstrap dark) */
        padding: 60px 0; /* Consistent vertical padding */
    }
    .bank-logo {
        max-width: 100%;
        height: auto;
        /* Optional: Add a small border or shadow to logos if needed for visibility */
    }
    .bank-card {
        padding: 15px;
        text-align: center;
        /* Ensures the text is centered beneath the logo */
    }


/* ... (KEEP all previous styles including section-dark-bg and card-dark-bg) ... */

    /* Custom CSS for the Light Section (reusing the one from BANKING) */
    .section-light-bg {
        background-color: #f8f9fa; /* Very light gray/off-white background */
        color: #212529; /* Dark text color (standard Bootstrap dark) */
        padding: 60px 0; /* Consistent vertical padding */
    }
    .start-button {
        background-color: #342D6B; /* Matching the card/icon background color */
        color: white;
        padding: 12px 30px;
        font-size: 1.25rem;
        font-weight: bold;
        border: none;
        border-radius: 8px;
        transition: background-color 0.3s ease;
    }
    .start-button:hover {
        background-color: #262152; /* Darker shade on hover */
        color: white;
    }
    .divider-line {
        border-top: 2px solid #ced4da; /* Light gray line */
        width: 15%;
        margin: 0 auto 20px auto; /* Centered with bottom margin */
    }
    
    
    
    /* ... (KEEP all previous styles including section-dark-bg and section-light-bg) ... */

    /* Custom styles for Accordion in a dark section */
    .accordion-item {
        border-color: #4a4282; /* Lighter border color for contrast */
        margin-bottom: 8px; /* Space between items */
    }
    .accordion-button {
        background-color: #342D6B; /* Matches card background color */
        color: white;
        font-weight: 600;
        box-shadow: none;
    }
    .accordion-button:not(.collapsed) {
        background-color: #262152; /* Darker background when open */
        color: white;
        box-shadow: none;
    }
    .accordion-body {
        background-color: #f8f9fa; /* Light background for easy reading */
        color: #212529; /* Dark text for readability */
    }
    
    
    
    /* ... (KEEP all previous styles including section-dark-bg and section-light-bg) ... */

    /* Custom CSS for the Footer Section */
    .footer-dark-bg {
        background-color: ##27272b; /* Matching the main dark section color */
        color: white; /* Default text color */
        padding: 50px 0 20px 0; /* Vertical padding */
        font-size: 0.95rem;
    }
    .footer-dark-bg h5 {
        color: #f8f9fa; /* Slightly brighter white for headings */
        margin-bottom: 20px;
        font-weight: 700;
    }
    .footer-dark-bg a {
        color: #ced4da; /* Light gray for links */
        text-decoration: none;
        display: block; /* Makes each link a separate block */
        margin-bottom: 8px;
        transition: color 0.3s;
    }
    .footer-dark-bg a:hover {
        color: #ffffff; /* White on hover */
    }
    .social-icon-box {
        display: inline-block;
        color: white;
        font-size: 20px;
        margin-right: 15px;
        transition: color 0.3s;
    }
    .social-icon-box:hover {
        color: #8c7ae6; /* A slight purple tint on hover */
    }
    .footer-bottom {
        border-top: 1px solid #342D6B; /* Separator line */
        padding-top: 20px;
        margin-top: 30px;
        font-size: 0.85rem;
    }
    
    
    /* ... (KEEP all previous styles for .card-dark-bg, .icon-box, etc.) ... */

    /* DEFINITION FOR THIS SPECIFIC SECTION'S BACKGROUND IMAGE */
    .section-hero-bg {
        /* This line adds a dark, semi-transparent layer over the image AND sets the image itself. */
        /* Change the URL to your image's location. */
        background-image: linear-gradient(rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 0.7)), url('pobo.png');
        
        background-size: cover;          /* Ensures the image covers the entire area */
        background-position: center center; /* Centers the image */
        background-attachment: fixed;    /* Makes the background fixed while content scrolls (Optional parallax effect) */
        padding: 80px 0;                 /* Vertical padding for the section */
        color: white;                    /* Default text color for the section */
    }

    /* We need to ensure the text elements are white against the dark overlay */
    .section-hero-bg h2, .section-hero-bg h3 {
        color: white;
    }

    /* We must also ensure the card background remains visible, so we keep the card styles: */
    .card-dark-bg {
        background-color: rgba(52, 45, 107, 0.9); /* Using RGBA for slight transparency over the image */
        color: white; 
        padding: 30px;
        border-radius: 8px;
        height: 100%;
        /* Add subtle border for definition against the dark background */
        border: 1px solid rgba(255, 255, 255, 0.1); 
    }
    
    /* Ensure the white icon box and text inside the card are clear */
    .icon-box {
        background-color: white;
        color: #342D6B; /* Icon color matches the card background color */
        /* ... other icon-box styles ... */
    }
    
    
    /* ... (KEEP all previous custom CSS styles for sections, cards, etc.) ... */

    /* -------------------------------------- */
    /* NEW STYLES FOR HEADER AND HERO */
    /* -------------------------------------- */
    .hero-section {
        background-color: #262152; /* Main dark background color */
        padding: 100px 0; /* Vertical padding, adjusted by min-height */
        min-height: 100vh; /* Makes the hero section fill the entire viewport height */
        color: white;
        position: relative; /* Needed for absolute positioning of design elements (if we added them) */
    }

    /* Transparent Navigation Bar */
    .navbar-transparent {
        position: absolute; /* Takes the nav out of the document flow */
        top: 0;
        left: 0;
        right: 0;
        z-index: 1030; /* Ensures the nav is always on top of other elements */
        background-color: transparent !important; /* Forces transparency */
        padding-top: 20px;
    }
    .navbar-transparent .nav-link, 
    .navbar-transparent .navbar-brand {
        color: white !important; /* Ensures links and brand are white */
        font-weight: 500;
    }
    .navbar-transparent .navbar-brand {
        font-weight: 700;
        font-size: 1.5rem;
        /* Optional: Style the 'yourbrand' circle logo if it were an image/icon */
    }
    .navbar-transparent .nav-link:hover {
        color: #4ce4e7 !important; /* Hover color matches the accent */
    }

    /* Hero Text Styling */
    .hero-title {
        font-size: 4rem;
        font-weight: 800;
        margin-top: 20vh; /* Pushes the title down, away from the transparent nav */
    }
    .hero-subtitle {
        font-size: 1.1rem;
        max-width: 600px;
        margin: 15px auto 30px auto;
        line-height: 1.8;
    }
    .hero-btn {
        background-color: #4ce4e7; /* Accent color button */
        color: #262152; /* Dark text on bright button */
        border: none;
        font-weight: bold;
        padding: 10px 30px;
        border-radius: 5px;
        transition: opacity 0.3s;
    }
    

    /* Note: The abstract shapes and lines in the image would require 
       complex CSS, SVG, or an image file to replicate exactly. 
       We will focus on the structure and background color. */
       
  </style>

</head>

<body>
    
  <nav class="navbar navbar-expand-lg navbar-dark navbar-transparent">
    <div class="container">
        <a class="navbar-brand" href="#">
            <i class="far fa-circle" style="color:#4ce4e7; margin-right: 5px;"></i> SUREXGATE
        </a>
        
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        
        <div class="collapse navbar-collapse justify-content-end" id="navbarNav">
            <ul class="navbar-nav">
                <li class="nav-item"><a class="nav-link active" aria-current="page" href="#">Home</a></li>
                <li class="nav-item"><a class="nav-link" href="about.php">About</a></li>
                <li class="nav-item"><a class="nav-link" href="about.php">Contact</a></li>
            </ul>
        </div>
    </div>
</nav>


<section class="hero-section text-center">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-12 col-lg-8">
                
                <br><br><br><br><br><br><br><br><br>
               <a href="login.php" class="btn hero-btn">
    Learn More
</a>
                
                </div>
        </div>
    </div>
</section>

<section class="mini-info">
  <div class="container">
    <h2>Why Choose SurexGate?</h2>
    <p>
      Built for everyday users and online traders, SurexGate offers a fast,
      secure, and transparent way to hold, send, and receive money without stress.
      Your safety comes first — always.
    </p>
    
    <br><br>
     <div href="login.php" class="buttons">
      <button class="btn btn-outlined">Learn More</button>
    </div>
  </div>
</section>

<br>

</style>

<section class="section-dark-bg">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center mb-5">
                <h2 class="display-5 fw-bold text-uppercase">
                    WHO CAN USE SREXGATE FOR TRANSACTIONS?
                </h2>
            </div>
        </div>

        <div class="row justify-content-center g-4">
            
            <div class="col-12 col-md-6 col-lg-4">
                <div class="card-dark-bg">
                    <div class="icon-box">
                        <i class="fas fa-sack-dollar"></i> </div>
                    
                    <h3>Buyers</h3>
                    <p>If you ever get to buy anything online, be it an item or a service, then Surexgate is for you.</p>
                    <p class="mt-4">You should never risk losing your hard-earned money to fraudsters who pose as genuine sellers online.</p>
                </div>
            </div>

            <div class="col-12 col-md-6 col-lg-4">
                <div class="card-dark-bg">
                    <div class="icon-box">
                        <i class="fas fa-shopping-cart"></i> </div>

                    <h3>Sellers</h3>
                    <p>If you sell physical goods or services online, be it through Facebook, Instagram, WhatsApp or via other websites, you should always use Surexgate to receive your payments in order to protect you from unserious or even fraudulent buyers.</p>
                    <p class="mt-4">Our services apply to both individuals and registered businesses.</p>
                </div>
            </div>

            <div class="col-12 col-md-6 col-lg-4">
                <div class="card-dark-bg">
                    <div class="icon-box">
                        <i class="fas fa-user-plus"></i> </div>
                    
                    <h3>Others</h3>
                    <p>This group includes consultants, contractors and other categories of people that may not necessarily be seen as buyers or sellers in the traditional sense.</p>
                    <p class="mt-4">You can use Surexgate to carry out just about any legitimate transaction.</p>
                </div>
            </div>

        </div>
    </div>
</section>

<section class="section-hero-bg">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center mb-5">
                <h2 class="display-5 fw-bold text-uppercase">
                    WHY USE SUREXGATE?
                </h2>
                <p class="lead mt-3">
                    Protect your transactions, guarantee satisfaction, and trade with confidence.
                </p>
            </div>
        </div>

        <div class="row justify-content-center g-4">
            
            <div class="col-12 col-md-6 col-lg-4">
                <div class="card-dark-bg text-center">
                    <div class="icon-box">
                        <i class="fas fa-shield-alt"></i> 
                    </div>
                    
                    <h3>Guaranteed Safety</h3>
                    <p>Money is held securely by licensed commercial banks until both parties confirm satisfaction with the transaction.</p>
                    <p class="mt-4">Eliminate the risk of dealing with online fraudsters and fake sellers/buyers.</p>
                </div>
            </div>

            <div class="col-12 col-md-6 col-lg-4">
                <div class="card-dark-bg text-center">
                    <div class="icon-box">
                        <i class="fas fa-balance-scale"></i>
                    </div>

                    <h3>Fair Dispute Resolution</h3>
                    <p>In the event of a disagreement, our impartial resolution process ensures fairness for both the Buyer and the Seller.</p>
                    <p class="mt-4">Clear terms and documented steps provide peace of mind throughout the entire process.</p>
                </div>
            </div>

            <div class="col-12 col-md-6 col-lg-4">
                <div class="card-dark-bg text-center">
                    <div class="icon-box">
                        <i class="fas fa-handshake"></i>
                    </div>
                    
                    <h3>Build Trust</h3>
                    <p>Sellers appear more credible when they offer a secure escrow option, increasing conversion and customer loyalty.</p>
                    <p class="mt-4">Use a reliable service backed by NDIC-insured, CBN-licensed banks (as seen in the Banking section).</p>
                </div>
            </div>

        </div>
    </div>
</section>

<section class="section-light-bg">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center mb-5">
                <hr class="w-25 mx-auto mb-3" style="border-top: 2px solid #000;">
                
                <h2 class="display-5 fw-bold text-uppercase">
                    BANKING
                </h2>
                
                <p class="lead w-75 mx-auto mt-4">
                    To help ensure that your money is safe, Surexgate only makes use of the following commercial banks that are licensed by the Central Bank of Nigeria and insured by the Nigerian Deposit Insurance Corporation (NDIC).
                </p>
            </div>
        </div>

        <div class="row justify-content-center g-5">
            
            <div class="col-6 col-sm-4 col-md-4 col-lg-3">
                <div class="bank-card">
                    <img src="access.jpg" alt="Access Bank Logo" class="bank-logo"> 
                    <p class="mt-2 fw-semibold">Access Bank Plc</p>
                </div>
            </div>

            <div class="col-6 col-sm-4 col-md-4 col-lg-3">
                <div class="bank-card">
                    <img src="zenith.jpg" alt="Zenith Bank Logo" class="bank-logo">
                    <p class="mt-2 fw-semibold">Zenith Bank Plc</p>
                </div>
            </div>

            <div class="col-6 col-sm-4 col-md-4 col-lg-3">
                <div class="bank-card">
                    <img src="gtb.jpg" alt="Guaranty Trust Bank Logo" class="bank-logo">
                    <p class="mt-2 fw-semibold">Guaranty Trust Bank Plc</p>
                </div>
            </div>
            
            <div class="w-100"></div> <div class="col-6 col-sm-4 col-md-4 col-lg-3">
                <div class="bank-card">
                    <img src="stanbic.jpg" alt="Stanbic IBTC Bank Logo" class="bank-logo">
                    <p class="mt-2 fw-semibold">Stanbic IBTC Bank</p>
                </div>
            </div>

            <div class="col-6 col-sm-4 col-md-4 col-lg-3">
                <div class="bank-card">
                    <img src="uba.jpg" alt="UBA Logo" class="bank-logo">
                    <p class="mt-2 fw-semibold">UBA Africa's Global Bank</p>
                </div>
            </div>

        </div>
    </div>
</section>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>

<section class="section-light-bg text-center">
    <div class="container py-5">
        
        <div class="row mb-5 d-none d-lg-flex justify-content-between">
            <div class="col-6 text-start text-secondary"></div>
            <div class="col-6 text-end text-secondary"></div>
        </div>

        <hr class="divider-line">
        
        <p class="mb-4">
            Learn more about surexgate service in Nigeria.
        </p>

        <h2 class="display-4 fw-bold mb-4">
            START TRANSACTION
        </h2>
        
        <p class="lead mb-5">
            Click on the <b>Start Transaction</b> button below to get started.
        </p>

        <a href="#" class="btn start-button">
            Start Transaction
        </a>

    </div>
</section>

<section class="section-dark-bg">
    <div class="container py-5">
        
        <div class="row">
            <div class="col-12 text-center mb-5">
                <h2 class="display-5 fw-bold text-uppercase text-white">
                    FREQUENTLY ASKED QUESTIONS
                </h2>
                <p class="lead text-white-50">
                    Find quick answers to the most common inquiries about EscrowLock.
                </p>
            </div>
        </div>

        <div class="row justify-content-center">
            <div class="col-12 col-lg-9">
                
                <div class="accordion" id="faqAccordion">

                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingOne">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                1. What is an Surexgate service?
                            </button>
                        </h2>
                        <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                An Surexgate service is a financial arrangement where a third party holds and regulates payment of the funds required for two parties involved in a transaction. It helps ensure that both the buyer and the seller fulfill their agreed-upon obligations before the payment is released.
                            </div>
                        </div>
                    </div>

                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwo">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                2. How much does Surexgate charge for its service?
                            </button>
                        </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                The fee varies depending on the transaction value. We charge a small percentage fee (typically between 1% to 3%) of the total transaction amount. Please consult our pricing page for a detailed breakdown.
                            </div>
                        </div>
                    </div>

                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingThree">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                3. What happens if there is a dispute?
                            </button>
                        </h2>
                        <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                Surexgate has a robust dispute resolution process. If a disagreement arises, both parties submit evidence, and our team acts as an impartial adjudicator based on the agreed terms of the transaction. Funds are only released or returned once a fair resolution is reached.
                            </div>
                        </div>
                    </div>
                    
                    
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingfour">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                2. What locations do you serve, Nigeria, Ghana, or ...?
                            </button>
                        </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
Our eCommerce and escrow service is  online-based, so we currently serve all locations in Nigeria – be it Lagos, Abuja, Port Harcourt, Onitsha, Kano, Kaduna, Enugu, Ogun and other areas in Nigeria.  
International users intending to transact in Nigerian Naira can currently use our service. 
More currencies will be added soon to cater for wider locations including Ghana, Kenya and other African countries.                            </div>
                        </div>
                    </div>

                </div>

            </div>
        </div>
    </div>
</section>
</div>

<footer class="footer-dark-bg">
    <div class="container">
        <div class="row">
            
            <div class="col-6 col-md-3 mb-4">
                <h5>Quick Links</h5>
                <a href="#">Home</a>
                <a href="#">How it Works</a>
                <a href="#">Pricing</a>
                <a href="#">Bank Verification</a>
            </div>

            <div class="col-6 col-md-3 mb-4">
                <h5>Legal</h5>
                <a href="#">Terms & Conditions</a>
                <a href="#">Privacy Policy</a>
                <a href="#">Escrow Agreement</a>
                <a href="#">Disclaimer</a>
            </div>

            <div class="col-6 col-md-3 mb-4">
                <h5>Contact Us</h5>
                <p>
                    <i class="fas fa-map-marker-alt me-2"></i> Lagos, Nigeria
                </p>
                <p>
                    <i class="fas fa-envelope me-2"></i> info@Surexgate.com
                </p>
                <p>
                    <i class="fas fa-phone-alt me-2"></i> +234 844 000 0000
                </p>
            </div>

            <div class="col-6 col-md-3 mb-4">
                <h5>About Surexgate</h5>
                <p>
                    Your trusted, secure Surexgate service provider dedicated to protecting buyers and sellers online.
                </p>
                <div class="mt-3">
                    <a href="#" class="social-icon-box"><i class="fab fa-facebook-f"></i></a>
                    <a href="#" class="social-icon-box"><i class="fab fa-instagram"></i></a>
                    <a href="#" class="social-icon-box"><i class="fab fa-linkedin-in"></i></a>
                </div>
            </div>

        </div>

        <div class="row footer-bottom text-center text-md-start">
            <div class="col-12 col-md-6 mb-2">
                &copy; <span id="year">2024</span> Surexgate. All Rights Reserved.
            </div>
            <div class="col-12 col-md-6 text-md-end">
                Powered by <h4>Surexgate</h4>
            </div>
        </div>

    </div>
</footer>

<script>
    document.getElementById('year').textContent = new Date().getFullYear();
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
</body>
</html>
