<?php
declare(strict_types=1);
require_once __DIR__.'/../includes/config.php';
?>

<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
</head>

<link rel="stylesheet" href="/public/assets/landing.css">
<div class="container">
  <div class="nav">
    <div class="brand"><div class="logo"></div><h1>Terms</h1></div>
    <div class="actions">
      <a class="btn ghost" href="<?= url('login.php') ?>">Login</a>
      <a class="btn" href="<?= url('register.php') ?>">Create account</a>
    </div>
  </div>

  <section class="section legal">
    <h2>Terms of Use</h2>
    <div class="card">
      <h3>1. Acceptance</h3>
      <p class="muted">By using SurexGate, you agree to these terms.</p>

      <h3>2. Nature of Service</h3>
      <p class="muted">This is a mini-bank application for business purposes only. Real banking service is provided.</p>

      <h3>3. Accounts & Security</h3>
      <p class="muted">Keep your credentials safe. We use hashed passwords; you’re responsible for your device security.</p>

      <h3>4. Content & Conduct</h3>
      <p class="muted">Don’t attempt abuse, reverse engineering, or illegal activity.</p>

      <h3>5. Liability</h3>
      <p class="muted">The app is provided “as is” without warranties. We’re not liable for any loss arising from use.</p>

      <h3>6. Changes</h3>
      <p class="muted">We may update these terms. Continued use means acceptance.</p>

      <h3>7. Contact</h3>
      <p class="muted">Questions? Email <a href="mailto:admin@surexgate.com">admin@surexgate.com</a>.</p>
    </div>
  </section>

  <div class="footer">
    <div class="nav" style="padding:0">
      <a href="<?= url('index.php') ?>">Home</a>
      <span>&nbsp;·&nbsp;</span>
      <a href="<?= url('about.php') ?>">About</a>
      <span>&nbsp;·&nbsp;</span>
      <a href="<?= url('faq.php') ?>">FAQ</a>
    </div>
  </div>
</div>
<?php require_once __DIR__.'/../includes/footer.php'; ?>
