<?php
require_once __DIR__.'/../includes/db.php';
require_once __DIR__.'/../includes/auth.php';
require_once __DIR__.'/../includes/helpers.php';
require_login();
$page_title = "Settings";

$ok = $err = '';

// Load current user
$st = $pdo->prepare("SELECT id, fullname, email FROM users WHERE id = :id");
$st->execute([':id' => $_SESSION['uid']]);
$user = $st->fetch();
if (!$user) { header('Location: login.php'); exit; }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $fullname = trim($_POST['fullname'] ?? '');
  $email    = trim($_POST['email'] ?? '');

  if ($fullname === '' || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
    $err = 'Enter a valid name and email.';
  } else {
    // email not used by someone else
    $dupe = $pdo->prepare("SELECT id FROM users WHERE email = :e AND id <> :id LIMIT 1");
    $dupe->execute([':e'=>$email, ':id'=>$user['id']]);
    if ($dupe->fetch()) {
      $err = 'That email is already in use.';
    } else {
      $upd = $pdo->prepare("UPDATE users SET fullname = :f, email = :e WHERE id = :id");
      $upd->execute([':f'=>$fullname, ':e'=>$email, ':id'=>$user['id']]);
      $ok = 'Profile updated.';
      $user['fullname'] = $fullname;
      $user['email']    = $email;
      $_SESSION['fullname'] = $fullname;
      $_SESSION['email']    = $email;
    }
  }
}

include __DIR__.'/../includes/header.php';
?>

<head>
    <!-- Bootstrap CSS (Latest 5.x version) -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-..." crossorigin="anonymous">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">

</head>
<style>
/* === PIN MODAL FIXED CENTER OVERLAY === */
.pin-modal {
  display: none;
  position: fixed;
  inset: 0;
  width: 100vw;
  height: 100vh;
  background: rgba(0, 0, 0, 0.55);
  backdrop-filter: blur(4px);
  z-index: 9999;
  align-items: center;
  justify-content: center;
  transition: opacity 0.3s ease;
}

.pin-modal.show {
  display: flex !important;
  animation: fadeInScale 0.35s ease forwards;
}

@keyframes fadeInScale {
  from {
    opacity: 0;
    transform: scale(0.9);
  }
  to {
    opacity: 1;
    transform: scale(1);
  }
}

/* Optional: Button hover polish */
.pin-modal button {
  transition: all 0.2s ease;
}

.pin-modal button:hover {
  transform: scale(1.05);
  opacity: 0.9;
}

#verifyPinBtn { background:#111;color:#fff; }
#cancelPinBtn { background:#ccc;color:#000; }



.mobile-bottom-nav {
    position: fixed;
    bottom: 25px;
    left: 0;
    width: 100%;
    background: #ffffff;
    border-top: 1px solid #ddd;
    display: flex;
    justify-content: space-around;
    padding: 10px 0 8px; 
    z-index: 9999;

    /* 🔥 fixes disappearing labels */
    height: 65px;
    overflow: visible;
}
.mobile-bottom-nav .nav-item span {
    display: block;
    font-size: 12px;
    line-height: 14px;  /* 🔥 prevents text cut-off */
}


.mobile-bottom-nav .nav-item {
    text-align: center;
    color: #555;
    font-size: 12px;
    text-decoration: none;
}

.mobile-bottom-nav .nav-item i {
    display: block;
    font-size: 20px;
    margin-bottom: 2px;
}

.mobile-bottom-nav .nav-item.active,
.mobile-bottom-nav .nav-item:hover {
    color: #0d6efd; /* Bootstrap blue */
}
body {
    padding-bottom: 80px; /* enough space for the bottom menu */
}


</style>

<div class="row g-4">
  <div class="col-md-9">

    <div class="card shadow-sm mb-4">
      <div class="card-body">
        <h5 class="card-title">Profile</h5>
        <?php if($ok): ?><div class="alert alert-success"><?= sanitize($ok) ?></div><?php endif; ?>
        <?php if($err): ?><div class="alert alert-danger"><?= sanitize($err) ?></div><?php endif; ?>
        <form method="post" class="row g-3" autocomplete="off">
          <div class="col-12">
            <label class="form-label">Full name</label>
            <input name="fullname" value="<?= sanitize($user['fullname']) ?>" class="form-control" required>
          </div>
          <div class="col-12">
            <label class="form-label">Email</label>
            <input name="email" type="email" value="<?= sanitize($user['email']) ?>" class="form-control" required>
          </div>
          <div class="col-12">
            <button class="btn btn-dark">Save changes</button>
          </div>
        </form>
      </div>
    </div>

    <div class="card shadow-sm">
      <div class="card-body">
        <h5 class="card-title">Security</h5>
        <p class="mb-0"><a href="password.php" class="btn btn-outline-secondary">Change password →</a></p>
      </div>
    </div>

  </div>
</div>

<!-- Bottom Mobile Nav -->
<nav class="mobile-bottom-nav d-md-none">
    <a href="dashboard.php" class="nav-item">
        <i class="bi bi-speedometer2"></i>
        <span>Home</span>
    </a>
    <a href="transactions.php" class="nav-item">
        <i class="bi bi-receipt"></i>
        <span>Transactions</span>
    </a>
    <a href="add-money.php" class="nav-item">
        <i class="bi bi-plus-circle"></i>
        <span>Add</span>
    </a>
    <a href="settings.php" class="nav-item">
        <i class="bi bi-gear"></i>
        <span>Settings</span>
    </a>
    <a href="logout.php" class="nav-item">
        <i class="bi bi-box-arrow-right"></i>
        <span>Logout</span>
    </a>
</nav>




<?php include __DIR__.'/../includes/footer.php'; ?>
