<?php
declare(strict_types=1);
require_once __DIR__.'/../includes/config.php';
require_once __DIR__.'/../includes/helpers.php';
require_once __DIR__.'/../includes/db.php';

$err = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $name  = trim($_POST['fullname'] ?? '');
  $email = strtolower(trim($_POST['email'] ?? ''));
  $pass  = $_POST['password'] ?? '';

  if (strlen($name) < 2) $err = 'Enter your full name.';
  elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) $err = 'Enter a valid email.';
  elseif (strlen($pass) < 6) $err = 'Password must be at least 6 characters.';
  else {
    $hash = password_hash($pass, PASSWORD_DEFAULT);
    $acct = null;
    for ($i=0; $i<5; $i++) {
      $cand = str_pad((string)random_int(0, 9999999999), 10, '0', STR_PAD_LEFT);
      $q = $pdo->prepare("SELECT 1 FROM users WHERE account_number=?");
      $q->execute([$cand]);
      if (!$q->fetch()) { $acct = $cand; break; }
    }
    if ($acct === null) {
      $err = 'Could not allocate an account number. Please try again.';
    } else {
      $st = $pdo->prepare("INSERT INTO users (fullname,email,password_hash,account_number,balance_cents,is_admin) VALUES (:n,:e,:h,:a,0,0)");
      try { $st->execute([':n'=>$name, ':e'=>$email, ':h'=>$hash, ':a'=>$acct]); header('Location: ' . url('login.php?registered=1')); exit; }
      catch(Throwable $e){ $err = (isset($e->errorInfo[1]) && $e->errorInfo[1]===1062) ? 'That email is already registered.' : 'Signup failed. Please try again.'; }
    }
  }
} 
?>
<!doctype html>
<html lang="en"><meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Register  SurexGate</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
<link rel="stylesheet" href="/public/assets/auth_modern.css">

<style>
/* -------------------------------------- */
/* 1. OVERALL LAYOUT AND ALIGNMENT */
/* -------------------------------------- */
/* Use .auth-screen (from your existing code) for the background */
.auth-screen {
    /* Retain full height */
    min-height: 100vh;
    /* Use Flexbox for positioning */
    display: flex;
    /* Center the card vertically */
    align-items: center; 
    /* ALIGN TO THE LEFT: */
    justify-content: flex-start; 
    /* Add horizontal space on the left side of the card */
   

    flex-wrap: nowrap; 
}
body {
    /* Your body style for the background image */
    background: url("/public/assets/levi.jpg") center/cover no-repeat;
    /* Ensure the body is full size for .auth-screen to work */
    margin: 0;
    width: 100%;
    height: 100%;
}


.card {
    /* Modified: This is now the main container for the split view */
    width: 90%;
    max-width: 800px; 
    height: 500px; 
    display: flex; 
    padding: 0; 
    background: transparent; 
    backdrop-filter: none; 
    border: none;
    border-radius: 16px; /* Apply rounding to the whole container */
    overflow: hidden; 
}

/* -------------------------------------- */
/* 2. LEFT PANEL (WELCOME! Side) */
/* -------------------------------------- */
.left-panel {
    flex: 1; 
    background-color: transparent; 
    color: white;
    padding: 40px;
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
    background: transparent; 
    box-shadow: 0 0 20px rgba(0, 119, 201, 0.4);
}
.left-panel .welcome-text {
    font-size: 2.5rem;
    font-weight: 800;
    text-transform: uppercase;
    letter-spacing: 2px;
}

/* -------------------------------------- */
/* 3. RIGHT PANEL (REGISTER FORM Side) */
/* -------------------------------------- */
.right-panel {
    flex: 1; 
    background: rgba(0,0,0,0.5); 
    backdrop-filter: blur(6px); 
    padding: 40px;
    display: flex;
    flex-direction: column;
    justify-content: center;
    color: #fff;
}
.right-panel .card-title {
    font-size: 2rem;
    font-weight: 700;
    margin-bottom: 5px;
    color: #fff;
}
.right-panel .card-sub {
    margin-bottom: 20px;
    color: #fff;
}
.right-panel .error {
    color: #ff5757; /* Error messages stand out */
    padding: 10px;
    border: 1px solid #ff5757;
    border-radius: 5px;
    margin-bottom: 15px;
}


/* -------------------------------------- */
/* 4. FORM FIELD STYLES (WITH ICONS) */
/* -------------------------------------- */
.input {
    display: flex;
    align-items: center;
    background: rgba(255,255,255,0.1);
    border: 1px solid rgba(255,255,255,0.2);
    border-radius: 8px; 
    padding: 0;
    margin-bottom: 15px;
    color: #fff;
}
.input input {
    flex-grow: 1;
    background: transparent;
    border: none;
    padding: 12px 10px;
    color: #fff;
    outline: none;
}
.input i {
    padding: 0 15px;
    color: rgba(255,255,255,0.6);
    font-size: 1.1rem;
}
.input:focus-within {
    border-color: #00aaff; /* Highlight border on focus */
}
.label {
    display: none; /* Hide label, using placeholders/icons */
}

/* Button style */
.btn {
    width: 100%;
    padding: 12px;
    background: linear-gradient(90deg, #0077c9, #00aaff); 
    border: none;
    border-radius: 25px; 
    color: #fff;
    font-weight: bold;
    margin-top: 20px;
    transition: all 0.3s;
}
.btn:hover {
    box-shadow: 0 5px 15px rgba(0, 119, 201, 0.4);
}

.links {
    text-align: center;
    margin-top: 15px;
    font-size: 0.9rem;
}
.links a {
    color: #00aaff;
    text-decoration: none;
    margin-left: 5px;
}
.links a:hover {
    color: #fff;
}

@media (max-width: 767.98px) {
    /* 1. Stack the Login Card Components */
    .card {
        flex-direction: column; /* Stacks left/right panels vertically */
        height: auto; /* Allow card height to adjust to content */
        max-width: 90%; /* Use full width on mobile */
        margin: 20px auto; /* Center the card and add vertical space */
    }

    /* 2. Hide the 'WELCOME!' panel to save vertical space */
    .left-panel {
        display: none;
    }

    /* 3. Center the form on mobile */
    .auth-screen {
        /* Overrides the desktop 'justify-content: flex-start' */
        justify-content: center;
        /* Remove the large left padding */
        padding-left: 0;
    }

    /* 4. Adjust padding and text size for better readability on small screens */
    .right-panel {
        padding: 30px 20px; /* Reduce padding */
        /* Ensure the form side background has rounding on the top too, 
           since the left-panel is now hidden. */
        border-radius: 16px; 
    }
    
    .right-panel .card-title {
        font-size: 1.5rem; /* Make the title slightly smaller */
    }
}
</style>

<body>
    <div class="auth-screen">
        <div class="card">
            
            <div class="left-panel d-none d-md-flex">
                <div class="welcome-text">JOIN US!</div>
                <i class="fas fa-user-plus" style="font-size: 6rem; opacity: 0.2; margin-top: 20px;"></i>
            </div>

            <div class="right-panel">
                <div class="card-head">
                    <a href="https://whitemanmoney.com/public/index.php" style="display:none;"><div class="brand-logo" style="background-image:url('/public/assets/logo.jpeg')"></div> </a>
                    
                    <div class="card-title">Create Account</div>
                    <p class="card-sub">It takes less than a minute.</p>
                </div>

                <div class="card-body">
                    <?php if (!empty($err)): ?><div class="error"><?= sanitize($err) ?></div><?php endif; ?>

                    <form class="form" method="post" autocomplete="off">
                        
                        <div>
                            <div class="label">Full name</div>
                            <div class="input">
                                <i class="fas fa-id-card"></i>
                                <input type="text" name="fullname" value="<?= isset($name)?sanitize($name):'' ?>" placeholder="Full Name" required>
                            </div>
                        </div>

                        <div>
                            <div class="label">Email</div>
                            <div class="input">
                                <i class="fas fa-envelope"></i>
                                <input type="email" name="email" value="<?= isset($email)?sanitize($email):'' ?>" placeholder="Email Address" required>
                            </div>
                        </div>

                        <div>
                            <div class="label">Password (min 6)</div>
                            <div class="input">
                                <i class="fas fa-key"></i>
                                <input type="password" name="password" minlength="6" placeholder="Password (min 6 chars)" required>
                            </div>
                        </div>
                        
                        <button class="btn">Create my account</button>
                    </form>

                    <div class="links">
                        <span>Already have an account?</span>
                        <a href="<?= url('login.php') ?>">Sign in</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>

</html>
