<?php
declare(strict_types=1);
require_once __DIR__.'/../includes/config.php';
require_once __DIR__.'/../includes/helpers.php';
require_once __DIR__.'/../includes/db.php';

$err = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $email = trim($_POST['email'] ?? '');
  $pass  = $_POST['password'] ?? '';
  $st = $pdo->prepare("SELECT id,fullname,email,password_hash,is_admin FROM users WHERE LOWER(email)=LOWER(:e) LIMIT 1");
  $st->execute([':e'=>$email]);
  if ($u = $st->fetch()) {
    if (password_verify($pass, $u['password_hash'])) {
      if (session_status() !== PHP_SESSION_ACTIVE) session_start();
      session_regenerate_id(true);
      $_SESSION['uid']      = (int)$u['id'];
      $_SESSION['fullname']= $u['fullname'];
      $_SESSION['email']   = $u['email'];
      $_SESSION['is_admin']= (int)$u['is_admin'];
      header('Location: ' . url('dashboard.php')); exit;
    }
  }
  $err = 'Invalid email or password.';
}
?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
<!doctype html>
<html lang="en"><meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Login ·SurexGate </title>
<link rel="stylesheet" href="/public/assets/auth_modern.css">

<style>
   
/* -------------------------------------- */
/* 1. DESKTOP/LARGE SCREEN STYLES */
/* -------------------------------------- */

/* The main container for the entire screen */
.auth-screen {
    min-height: 100vh;
    display: flex;
    align-items: center; 
    /* Desktop: ALIGN TO THE LEFT */
    justify-content: flex-start; 
    padding-left: 10%; /* Creates space on the right */
    flex-wrap: nowrap; 
}

/* The main login/register wrapper */
.card {
    width: 90%;
    max-width: 800px; 
    height: 500px; 
    display: flex; /* Enables split-screen */
    padding: 0; 
    background: transparent; 
    backdrop-filter: none; 
    border: none;
    border-radius: 16px; 
    overflow: hidden; 
}

/* LEFT PANEL (Blue side) */
.left-panel {
    flex: 1; 
    color: white;
    padding: 40px;
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
    background: linear-gradient(135deg, #0077c9 0%, #00aaff 100%); 
    box-shadow: 0 0 20px rgba(0, 119, 201, 0.4);
}
.left-panel .welcome-text {
    font-size: 2.5rem;
    font-weight: 800;
    text-transform: uppercase;
    letter-spacing: 2px;
}

/* RIGHT PANEL (Form side) */
.right-panel {
    flex: 1; 
    background: rgba(0,0,0,0.5); 
    backdrop-filter: blur(6px); 
    padding: 40px;
    display: flex;
    flex-direction: column;
    justify-content: center;
    color: #fff;
    /* Ensure the rounding is only on the right side for desktop */
    border-top-right-radius: 16px;
    border-bottom-right-radius: 16px;
    border-top-left-radius: 0;
    border-bottom-left-radius: 0;
}

/* Form field and Button styles (Simplified for clarity, assuming yours are working) */
.input {
    display: flex;
    align-items: center;
    background: rgba(255,255,255,0.1);
    border: 1px solid rgba(255,255,255,0.2);
    border-radius: 8px; 
    margin-bottom: 15px;
}
.input input {
    flex-grow: 1;
    background: transparent;
    border: none;
    padding: 12px 10px;
    color: #fff;
    outline: none;
}
.input i {
    padding: 0 15px;
    color: rgba(255,255,255,0.6);
}
.label { display: none; }
.btn {
    width: 100%;
    padding: 12px;
    background: linear-gradient(90deg, #0077c9, #00aaff); 
    border-radius: 25px; 
    color: #fff;
    font-weight: bold;
}

/* -------------------------------------- */
/* 2. MOBILE RESPONSIVENESS FIXES (Applies below 768px) */
/* -------------------------------------- */
@media (max-width: 767.98px) {
    /* Override desktop alignment and centering the card */
    .auth-screen {
        justify-content: center; /* Center the card horizontally */
        padding-left: 0; /* Remove left padding */
    }

    /* Stack and resize the main container */
    .card {
        flex-direction: column; /* Stack panels vertically */
        height: auto; /* Allow height to adjust */
        max-width: 90%; 
        margin: 20px auto; 
    }

    /* Hide the 'JOIN US!' panel to save vertical screen space */
    .left-panel {
        display: none;
    }

    /* Ensure the form panel takes on the full rounded corners */
    .right-panel {
        border-radius: 16px; /* Apply rounding to all corners */
        padding: 30px 20px; /* Adjust padding for mobile comfort */
    }
}

</style>
<body class="auth-screen">
    <div class="card">
        
        <div class="left-panel d-none d-md-flex">
            <div class="welcome-text">WELCOME!</div>
            <i class="fas fa-lock" style="font-size: 6rem; opacity: 0.2; margin-top: 20px;"></i>
        </div>

        <div class="right-panel">
            <div class="card-head">
                <div class="card-title">Log In</div>
                <p class="card-sub">Welcome back. Please enter your details.</p>
                </div>

            <div class="card-body">
                <?php if (!empty($err)): ?><div class="error"><?= sanitize($err) ?></div><?php endif; ?>

                <form class="form" method="post" autocomplete="off">
                    <div>
                        <div class="label">Email or Username</div>
                        <div class="input">
                            <i class="fas fa-user"></i>
                            <input type="email" name="email" value="<?= isset($email)?sanitize($email):'' ?>" placeholder="Email or Username" required>
                        </div>
                    </div>

                    <div>
                        <div class="label">Password</div>
                        <div class="input">
                            <i class="fas fa-lock"></i>
                            <input type="password" name="password" placeholder="Password" required>
                        </div>
                    </div>

                    <button class="btn">Log me in</button>
                </form>

                <div class="links">
                    <a href="<?= url('forgot.php') ?>">Forgot Password?</a> |
                    <a href="<?= url('register.php') ?>">Do not have an account?</a>
                </div>
            </div>
        </div>
    </div>
</body>

</html>
