<?php
declare(strict_types=1);
session_start();
require_once __DIR__ . '/../includes/bootstrap.php'; // loads $pdo, config, auth helpers

auth_require_login();
if (empty($_POST['csrf']) || !hash_equals($_SESSION['csrf'] ?? '', $_POST['csrf'])) {
  http_response_code(400); exit('Bad CSRF');
}
$uid = (int)$_SESSION['uid'];

if (!is_dir(KYC_DIR)) { mkdir(KYC_DIR, 0700, true); }
$userDir = KYC_DIR . '/' . $uid;
if (!is_dir($userDir)) { mkdir($userDir, 0700, true); }

$map = ['id_front'=>'id_front','id_back'=>'id_back','selfie'=>'selfie','poa'=>'proof_of_address'];
$allowed = ['image/jpeg','image/png','application/pdf'];
$max = 5 * 1024 * 1024;

$pdo->beginTransaction();
try {
  $ins = $pdo->prepare("INSERT INTO kyc_documents (user_id, doc_type, file_path, mime, size_bytes) VALUES (?,?,?,?,?)");

  foreach ($map as $field=>$type) {
    if (!isset($_FILES[$field]) || $_FILES[$field]['error'] === UPLOAD_ERR_NO_FILE) continue;
    $f = $_FILES[$field];
    if ($f['error'] !== UPLOAD_ERR_OK) throw new RuntimeException("Upload error: $field");
    if ($f['size'] > $max) throw new RuntimeException("File too large: $field");

    $finfo = finfo_open(FILEINFO_MIME_TYPE);
    $mime = finfo_file($finfo, $f['tmp_name']);
    if (!in_array($mime, $allowed, true)) throw new RuntimeException("Invalid type: $field");

    $ext = $mime === 'application/pdf' ? 'pdf' : (str_contains($mime,'png')?'png':'jpg');
    $name = $type . '-' . bin2hex(random_bytes(6)) . '.' . $ext;
    $dest = $userDir . '/' . $name;

    if (!move_uploaded_file($f['tmp_name'], $dest)) throw new RuntimeException('Save failed');

    $rel = "kyc/$uid/$name"; // store relative path (under /uploads)
    $ins->execute([$uid, $type, $rel, $mime, $f['size']]);
  }

  $pdo->prepare("UPDATE users SET kyc_status='pending', kyc_level=1, kyc_submitted_at=NOW() WHERE id=?")->execute([$uid]);

  $pdo->commit();
  header('Location: /public/dashboard.php?msg=kyc_submitted');
} catch (Throwable $e) {
  $pdo->rollBack();
  http_response_code(400);
  exit('KYC submit failed: '.$e->getMessage());
}
