<?php
require_once __DIR__.'/../includes/config.php';
require_once __DIR__.'/../includes/footer.php';

?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>SurexGate — Your everyday mini-bank</title>
  <link rel="stylesheet" href="/public/assets/landing.css">
</head>
<body>
  <header class="nav container">
    <div class="brand">
      <div class="logo"></div>
      <span>SurexGate</span>
    </div>
    <div class="actions">
      <a class="btn ghost" href="<?= url('login.php') ?>">Login</a>
      <a class="btn" href="<?= url('register.php') ?>">Create account</a>
    </div>
  </header>

  <main class="container">
    <section class="hero">
      <div class="col">
        <span class="badge">SIMPLE • SECURE • FAST</span>
        <h1>Empowering Digital Trust—<br>Banking Beyond Transactions</h1>
        <p>SurexGate is your secure digital mini-bank built for seamless escrow trading. Fund, hold, and transfer money confidently while we safeguard every step of your online exchange.
        Send and receive money, track balances, and manage your account in seconds. Designed for clarity, built for speed.</p>
        <div class="actions">
            <br>
         <span class="badge">What would you like to do?</span>
<br>
          <a class="btn" href="<?= url('register.php') ?>">Start Transaction</a>
          <a class="btn ghost" href="/public/faq.php">Learn more</a>
        </div>
      </div>

      <!-- plain image, no card/frame -->
      <div class="hero-media">
        <img src="/public/assets/images/logo3.png" alt="SurexGate app preview">
      </div>
    </section>
<br><br>

    <!-- rest of your sections ... -->
    <h1>FAQ</h1>
    
<section class="section faq">
    <h2>Common questions</h2>

    <details open>
      <summary>▾ Is this a real escrow service?</summary>
      <p class="muted">Yes — SurexGate is a verified digital escrow platform that securely holds funds between buyers and sellers until all agreed conditions are fulfilled. We ensure transparency and trust in every transaction</p>
    </details>

    <details>
      <summary>▾ How do I reset my password?</summary>
      <p class="muted">Click “Forgot Password” on the login page, follow the secure link sent to your registered email, and create a new password.</p>
    </details>

    <details>
      <summary>▾ Is my password and data safe?</summary>
      <p class="muted">Absolutely. All passwords are encrypted using industry-standard bcrypt hashing. We never store plain text passwords, and all transactions are protected with SSL security.</p>
    </details>

    <details>
      <summary>▾ How does SurexGate Escrow work?</summary>
      <p class="muted">Once a deal is initiated, the buyer’s payment is held securely in escrow until the seller fulfills the agreed terms. After both parties confirm completion, funds are released automatically.</p>
    </details>
    
    <details>
      <summary>▾ Where can I find the Terms and Policies?</summary>
      <p class="muted">You can review our Terms of Service and Privacy Policy on our Terms Page.</p>
    </details>
  </section>

  <!-- parara -->
<section class="brand-visual">
  <img
    src="https://whitemanmoney.com/public/assets/images/session_brand.png"
    srcset="https://whitemanmoney.com/public/assets/images/session_brand.png 480w,
            https://whitemanmoney.com/public/assets/images/session_brand.png 768w,
            https://whitemanmoney.com/public/assets/images/session_brand.png 1024w"
    sizes="(max-width: 600px) 80vw, 420px"
    alt="SURE x GATE logo"
    class="brand-logo"
    width="1024" height="683"  <!-- keeps layout stable -->
</section>




<section class="section legal">
    <h2>Terms of Use</h2>
    <div class="card">
      <h3>1. Acceptance of Terms</h3>
      <p class="muted">By accessing or using SurexGate, you agree to comply with and be bound by these Terms of Use. If you do not agree, you must discontinue use immediately.</p>

      <h3>2. Nature of Service</h3>
      <p class="muted">SurexGate provides a digital wallet and escrow-based transaction system designed to facilitate secure online trading between buyers and sellers. The Platform is not a licensed financial institution but operates as a digital payment and fund management service for business purposes only.</p>

      <h3>3. Account Registration and Security</h3>
      <p class="muted">Users must provide accurate information during registration and maintain the confidentiality of their login credentials. SurexGate employs encryption and password hashing for protection; however, users are responsible for the security of their personal devices and internet connections. Unauthorized use of another user’s account is strictly prohibited.</p>

      <h3>4. Content & Conduct</h3>
      <p class="muted">Users agree not to:</p>
<ul>
<li>engage in any fraudulent, illegal, or abusive activities</li>

<li>attempt to reverse-engineer, decompile, or otherwise tamper with the Platform</li>

<li>use the Platform for money laundering or prohibited transactions.</li></ul>
<p>SurexGate reserves the right to suspend or terminate any account that violates these rules.</p>

      <h3>5. Escrow and Transaction Policy</h3>
      <p class="muted">Funds transferred through SurexGate may be held temporarily in escrow until the completion of a transaction or mutual confirmation by both parties. The Platform acts solely as a facilitator and does not guarantee the performance or reliability of any buyer or seller.</p>

      <h3>6. Limitation of Liability</h3>
      <p class="muted">SurexGate is provided “as is” and “as available.” The Company makes no warranties, express or implied, regarding performance, availability, or suitability for a particular purpose. SurexGate shall not be liable for any loss, interruption, or damage arising from use or inability to use the Platform, including indirect or consequential damages.</p>

      <h3>7. Modification of Terms</h3>
      <p class="muted">SurexGate may modify or update these Terms at any time without prior notice. Continued use of the Platform constitutes acceptance of the revised Terms.</p>
      
      <h3>8. Governing Law</h3>
      <p class="muted">Questions? Email <a href="mailto:admin@surexgate.com">admin@surexgate.com</a>.</p>
    </div>
  </section>

  <div class="footer">
    <div class="nav" style="padding:0">
      <a href="<?= url('index.php') ?>">Home</a>
      <span>&nbsp;·&nbsp;</span>
      <a href="<?= url('about.php') ?>">About</a>
      <span>&nbsp;·&nbsp;</span>
      <a href="<?= url('faq.php') ?>">FAQ</a>
      <span>&nbsp;·&nbsp;</span>
      <a href="<?= url('terms.php') ?>">Terms</a>
    </div>
  </div>
</div>
<?php require_once __DIR__.'/../includes/footer.php'; 
require_once __DIR__.'/../includes/footer.php';?>
    
    
  </main>

</body>
</html>
