<?php
// Keep your necessary PHP includes here
require_once __DIR__.'/../includes/config.php';
require_once __DIR__.'/../includes/footer.php'; 
?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>SurexGate — Your everyday mini-bank</title>
    <link rel="stylesheet" href="/public/assets/landing.css">
    </head>
<body>

    <header class="main-header">
        <div class="container nav-bar">
            <div class="brand">
                <div class="logo"></div>
                <span>SurexGate</span>
            </div>
            <div class="actions">
                <a class="btn ghost" href="<?= url('login.php') ?>">Login</a>
                <a class="btn primary-btn" href="<?= url('register.php') ?>">Create account</a>
            </div>
        </div>
    </header>

    <main>
        <section class="section hero">
            <div class="container hero-content">
                <div class="col text-col">
                    <span class="badge">SIMPLE • SECURE • FAST</span>
                    <h1>Empowering Digital Trust—<br>Banking Beyond Transactions</h1>
                    <p>The best digital escrow payment service, offering reliable online and international buyer-protection, seller-protection, and transaction assurance solutions.</p>

                    <div class="actions">
                        <a class="btn primary-btn large-btn" href="<?= url('register.php') ?>">Start a Transaction</a>
                        <a class="btn ghost large-btn" href="/public/faq.php">Learn more</a>
                    </div>
                </div>

                <div class="col media-col">
                    <img 
                        src="/public/assets/images/logo3.png" 
                        alt="SurexGate App Dashboard"
                    >
                </div>
            </div>
        </section>
        
        <section id="about" class="section about-section container">
            <h2 class="section-title">Nigeria's Award-Winning Escrow Platform</h2>
            <div class="about-content">
                <p>SurexGate is a verified eCommerce and ICT company popular for its buyer and seller protection service. We securely receive and hold payment from a buyer, and then release it to the seller only when the buyer has received the transacted goods or services in pre-agreed condition.</p>
                <p>This approach protects each party from fraud or foul play, thereby enhancing trust in online transactions and supporting the growth of micro, small, and medium businesses across Africa.</p>
                <a href="<?= url('about.php') ?>" class="read-more">Continue Reading →</a>
            </div>
        </section>

        <section id="process" class="section process-section bg-light">
            <div class="container">
                <h2 class="section-title">Simple Steps to Using SurexGate</h2>
                <div class="steps-grid">
                    <div class="step-item">
                        <span class="step-number">1</span>
                        <h3>Agree to Terms & Start</h3>
                        <p>Buyer and Seller negotiate and agree on the product, price, and terms. One party, usually the buyer, starts the transaction on SurexGate.</p>
                    </div>
                    <div class="step-item">
                        <span class="step-number">2</span>
                        <h3>Buyer Deposits Payment</h3>
                        <p>Buyer makes a commitment by depositing the payment into a dedicated escrow account, where the money is safely locked.</p>
                    </div>
                    <div class="step-item">
                        <span class="step-number">3</span>
                        <h3>Seller Delivers Product</h3>
                        <p>Upon securing the payment, SurexGate informs the seller to proceed with delivering the goods or services to the buyer.</p>
                    </div>
                    <div class="step-item">
                        <span class="step-number">4</span>
                        <h3>Funds Are Released</h3>
                        <p>Once the buyer confirms receipt and satisfaction, SurexGate 'unlocks' the payment and releases it to the seller.</p>
                    </div>
                </div>
            </div>
        </section>

        <section id="audiences" class="section audiences-section container">
            <h2 class="section-title">Who Can Use SurexGate for Transactions?</h2>
            <div class="audiences-grid">
                <div class="audience-card">
                    <h3>Buyers</h3>
                    <p>Protect yourself from fraudsters. Never risk losing your money online—pay securely to our escrow account first.</p>
                </div>
                <div class="audience-card">
                    <h3>Sellers</h3>
                    <p>Avoid unreliable buyers and boost customer confidence. Receive payment assurance before shipping or service delivery.</p>
                </div>
                <div class="audience-card">
                    <h3>Consultants & Contractors</h3>
                    <p>Use SurexGate to manage funds for milestone-based projects, ensuring payment is released only upon project completion.</p>
                </div>
            </div>
        </section>

        <section class="section final-cta-section bg-primary">
            <div class="container text-center">
                <h2 class="text-white">Ready to Start Your Secure Transaction?</h2>
                <a class="btn large-btn final-cta-btn" href="<?= url('register.php') ?>">Start Transaction Now</a>
            </div>
        </section>

        <section id="faq" class="section faq-section container">
            <h2 class="section-title">Frequently Asked Questions</h2>
            </section>

        <section class="section about-footer-cta bg-light">
            <div class="container text-center">
                <h3>About SurexGate</h3>
                <p>SurexGate's escrow platform acts as an independent third-party to receive payment from the buyer, for onward release to the seller when the buyer has successfully received transacted goods/services in agreed condition.</p>
                <a class="btn primary-btn" href="<?= url('about.php') ?>">See More Benefits</a>
            </div>
        </section>

    </main>

    <footer class="main-footer">
        <div class="container footer-content">
            <p>&copy; 2025 SurexGate. All Rights Reserved.</p>
            <div class="footer-links">
                <a href="<?= url('index.php') ?>">Home</a>
                <a href="<?= url('about.php') ?>">About</a>
                <a href="<?= url('faq.php') ?>">FAQ</a>
                <a href="<?= url('terms.php') ?>">Terms</a>
            </div>
        </div>
    </footer>

</body>
</html>