<?php
declare(strict_types=1);
require_once __DIR__.'/../includes/config.php';
?>


<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
</head>

<link rel="stylesheet" href="/public/assets/landing.css">
<div class="container">
  <div class="nav">
    <div class="brand"><div class="logo"></div><h1>FAQ</h1></div>
    <div class="actions">
      <a class="btn ghost" href="<?= url('login.php') ?>">Login</a>
      <a class="btn" href="<?= url('register.php') ?>">Create account</a>
    </div>
  </div>

  <section class="section faq">
    <h2>Common questions</h2>

    <details open>
      <summary>Is this a real escrow service?</summary>
      <p class="muted">Yes SurexGate is a verified digital escrow platform that securely holds funds between buyers and sellers until all agreed conditions are fulfilled. We ensure transparency and trust in every transaction</p>
    </details>

    <details>
      <summary>How do I reset my password?</summary>
      <p class="muted">Click Forgot Password on the login page, follow the secure link sent to your registered email, and create a new password.</p>
    </details>

    <details>
      <summary>Is my password and data safe?</summary>
      <p class="muted">Absolutely. All passwords are encrypted using industry-standard bcrypt hashing. We never store plain text passwords, and all transactions are protected with SSL security.</p>
    </details>

    <details>
      <summary>How does SurexGate Escrow work?</summary>
      <p class="muted">Once a deal is initiated, the buyer's payment is held securely in escrow until the seller fulfills the agreed terms. After both parties confirm completion, funds are released automatically.</p>
    </details>
    
    <details>
      <summary>Where can I find the Terms and Policies?</summary>
      <p class="muted">You can review our Terms of Service and Privacy Policy on our Terms Page.</p>
    </details>
  </section>

  <div class="footer">
    <div class="nav" style="padding:0">
      <a href="<?= url('index.php') ?>">Home</a>
    
      <a href="<?= url('about.php') ?>">About</a>
      <a href="<?= url('faq.php') ?>">Faq</a>
      <a href="<?= url('terms.php') ?>">Terms</a>
    </div>
  </div>
</div>
<?php require_once __DIR__.'/../includes/footer.php'; ?>
