<?php
declare(strict_types=1);
ini_set('display_errors','1'); error_reporting(E_ALL);

// load db
$tries=[__DIR__.'/../includes/db.php', __DIR__.'/includes/db.php'];
$loaded=null; foreach($tries as $p){ if(file_exists($p)){ require_once $p; $loaded=$p; break; } }
if(!$loaded){ exit("Couldn't find db.php"); }

// find tables that have an email column
$sql = "SELECT TABLE_NAME, COLUMN_NAME 
        FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_SCHEMA = DATABASE() 
          AND COLUMN_NAME IN ('email','user_email','mail')";
$rows = $pdo->query($sql)->fetchAll();
if (!$rows) { exit("No tables with an email-like column found."); }

echo "<b>Loaded db.php from:</b> $loaded<br><br>";
echo "<b>Tables with email-like columns:</b><br>";
$tables = [];
foreach ($rows as $r) {
  $tables[$r['TABLE_NAME']] = true;
  echo "- {$r['TABLE_NAME']} (column {$r['COLUMN_NAME']})<br>";
}
echo "<hr>";

// show columns for each candidate table
foreach (array_keys($tables) as $t) {
  echo "<b>Columns in $t</b><br>";
  $cols = $pdo->query("SHOW COLUMNS FROM `$t`")->fetchAll();
  foreach ($cols as $c) {
    echo htmlspecialchars($c['Field']) . " : " . htmlspecialchars($c['Type']) . "<br>";
  }
  echo "<br>";
}
