<?php
declare(strict_types=1);
ini_set('display_errors','1'); error_reporting(E_ALL);

// Try both common include locations:
$tries = [
  __DIR__ . '/../includes/db.php', // includes is one level above /public
  __DIR__ . '/includes/db.php',    // includes inside /public
];

$loaded = null;
foreach ($tries as $p) {
  if (file_exists($p)) { require_once $p; $loaded = $p; break; }
}
if (!$loaded) { exit("Couldn't find db.php. Tried: " . implode(' | ', $tries)); }

$email = strtolower(trim($_GET['email'] ?? ''));
if ($email === '') { exit('Pass ?email=you@example.com'); }

echo "Loaded db.php from: $loaded<br>";

$stmt = $pdo->prepare("SELECT id,email,password FROM users WHERE LOWER(email)=?");
$stmt->execute([$email]);
$u = $stmt->fetch();

if (!$u) { exit("No user found for $email"); }

echo "Found user ID: {$u['id']}<br>";
$pwd = (string)$u['password'];
echo "Password length: " . strlen($pwd) . "<br>";
echo "Password prefix: " . htmlspecialchars(substr($pwd, 0, 4)) . "<br>";
echo (strpos($pwd, '$2y$') === 0) ? "Looks like bcrypt hash ✅" : "Does NOT look like bcrypt hash ❌";
