<?php
declare(strict_types=1);
ini_set('display_errors','1'); error_reporting(E_ALL);

// Load db.php from the right place
$tries=[__DIR__.'/../includes/db.php', __DIR__.'/includes/db.php'];
$loaded=null; foreach($tries as $p){ if(file_exists($p)){ require_once $p; $loaded=$p; break; } }
if(!$loaded){ exit("Couldn't find db.php"); }

$email = strtolower(trim($_GET['email'] ?? ''));
$pass  = $_GET['password'] ?? '';
if ($email==='' || $pass==='') {
  exit("Usage: ?email=you@example.com&password=YourPass123!");
}

echo "<b>Loaded db.php from:</b> ".htmlspecialchars($loaded)."<br>";

try {
  $row = $pdo->query("SELECT CURRENT_USER() AS who, DATABASE() AS db")->fetch();
  echo "<b>MySQL user:</b> ".htmlspecialchars($row['who']??'?')." | <b>DB:</b> ".htmlspecialchars($row['db']??'?')."<br><br>";
} catch (Throwable $e) {
  exit("DB test failed: " . htmlspecialchars($e->getMessage()));
}

$st = $pdo->prepare("SELECT id, email, password_hash FROM users WHERE LOWER(email)=? LIMIT 1");
$st->execute([$email]);
$u = $st->fetch();

if (!$u) {
  exit("❌ No user found for <b>".htmlspecialchars($email)."</b> in this database.");
}

$hash = (string)$u['password_hash'];
echo "Found user id: {$u['id']}<br>";
echo "password_hash length: ".strlen($hash)." | prefix: ".htmlspecialchars(substr($hash,0,4))."<br>";

if (strpos($hash,'$2y$') !== 0) {
  echo "⚠️ Stored password does NOT look like a bcrypt hash. Likely plain text or wrong format.<br>";
}

$ok = password_verify($pass, $hash);
echo $ok ? "✅ password_verify() = TRUE (password matches)" : "❌ password_verify() = FALSE (password does not match)";
