<?php
// Show where we are
echo "Current dir: " . __DIR__ . "<br>";

require_once __DIR__ . '/../includes/db.php';

echo 'DB_USER=' . (defined('DB_USER') ? DB_USER : '(not defined)') . "<br>";
echo 'DB_NAME=' . (defined('DB_NAME') ? DB_NAME : '(not defined)') . "<br>";

try {
  $dsn = 'mysql:host=' . DB_HOST . ';dbname=' . DB_NAME . ';charset=utf8mb4';
  $pdo = new PDO($dsn, DB_USER, DB_PASS, [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]);
  echo 'Connected OK';
} catch (PDOException $e) {
  echo 'ERROR: ' . $e->getMessage();
}
