<?php
declare(strict_types=1);
ini_set('display_errors','1'); error_reporting(E_ALL);
require_once __DIR__ . '/../includes/db.php'; // or '/includes/db.php' if includes is inside /public

$email = trim($_GET['email'] ?? '');
if ($email === '') exit('Add ?email=you@example.com to the URL');

$stmt = $pdo->prepare("SELECT id, email, LENGTH(password) AS phlen FROM users WHERE email = ?");
$stmt->execute([$email]);
$row = $stmt->fetch();
if (!$row) {
  exit("❌ No user found for: " . htmlspecialchars($email));
}
echo "✅ Found user ID {$row['id']} for " . htmlspecialchars($row['email']) . "<br>";
echo "Password hash length: " . (int)$row['phlen'];
