<?php
require_once __DIR__.'/../includes/db.php';
require_once __DIR__.'/../includes/auth.php';
require_once __DIR__.'/../includes/helpers.php';
require_admin();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') { header('Location: admin_cards.php'); exit; }
if (empty($_POST['csrf']) || $_POST['csrf'] !== ($_SESSION['csrf'] ?? '')) {
  flash_err('Bad CSRF.'); header('Location: admin_cards.php'); exit;
}

$card_id = (int)($_POST['card_id'] ?? 0);
$status  = $_POST['status'] ?? 'inactive';
if (!in_array($status, ['inactive','pending','active'], true)) $status='inactive';

$upd = $pdo->prepare("UPDATE cards SET status=:s WHERE id=:id");
$upd->execute([':s'=>$status, ':id'=>$card_id]);

flash_ok('Card status updated.');
header('Location: admin_cards.php'); exit;
