<?php
require_once __DIR__.'/../includes/db.php';
require_once __DIR__.'/../includes/auth.php';
require_once __DIR__.'/../includes/helpers.php';
require_admin();
$page_title = "Admin • Cards";

// fetch pending + recent
$rows = $pdo->query("
  SELECT c.id, c.user_id, c.card_number, c.exp_month, c.exp_year, c.status, u.fullname, u.email
  FROM cards c
  JOIN users u ON u.id=c.user_id
  ORDER BY FIELD(c.status,'pending','inactive','active'), c.id DESC
  LIMIT 200
")->fetchAll();

if (empty($_SESSION['csrf'])) $_SESSION['csrf']=bin2hex(random_bytes(16));

include __DIR__.'/../includes/header.php';
?>
<div class="row g-4">
  <div class="col-md-3"><?php include __DIR__.'/../includes/sidebar.php'; ?></div>
  <div class="col-md-9">
    <div class="card shadow-sm">
      <div class="card-body">
        <h5 class="card-title mb-3">Cards Admin</h5>
        <div class="table-responsive">
          <table class="table align-middle">
            <thead class="table-light">
              <tr>
                <th>User</th>
                <th>Email</th>
                <th>Card</th>
                <th>Expiry</th>
                <th>Status</th>
                <th class="text-end">Actions</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach($rows as $r): ?>
                <tr>
                  <td><?= sanitize($r['fullname']) ?></td>
                  <td><?= sanitize($r['email']) ?></td>
                  <td class="font-monospace"><?= sanitize($r['card_number']) ?></td>
                  <td><?= str_pad((string)$r['exp_month'],2,'0',STR_PAD_LEFT) ?>/<?= $r['exp_year'] ?></td>
                  <td>
                    <?php
                      $badge = ['inactive'=>'secondary','pending'=>'warning','active'=>'success'][$r['status']] ?? 'secondary';
                    ?>
                    <span class="badge text-bg-<?= $badge ?>"><?= sanitize($r['status']) ?></span>
                  </td>
                  <td class="text-end">
                    <form method="post" action="admin_update_card.php" class="d-inline">
                      <input type="hidden" name="csrf" value="<?= $_SESSION['csrf'] ?>">
                      <input type="hidden" name="card_id" value="<?= (int)$r['id'] ?>">
                      <select name="status" class="form-select form-select-sm d-inline w-auto">
                        <option value="inactive" <?= $r['status']==='inactive'?'selected':'' ?>>inactive</option>
                        <option value="pending"  <?= $r['status']==='pending'?'selected':'' ?>>pending</option>
                        <option value="active"   <?= $r['status']==='active'?'selected':'' ?>>active</option>
                      </select>
                      <button class="btn btn-sm btn-dark ms-2">Update</button>
                    </form>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>

      </div>
    </div>
  </div>
</div>
<?php include __DIR__.'/../includes/footer.php'; ?>
