<?php
declare(strict_types=1);
require_once __DIR__.'/../includes/config.php';
?>

<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
</head>
<link rel="stylesheet" href="/public/assets/landing.css">
<div class="container">
  <div class="nav">
    <div class="brand"><div class="logo"></div><h1>About</h1></div>
    <div class="actions">
      <a class="btn ghost" href="<?= url('login.php') ?>">Login</a>
      <a class="btn" href="<?= url('register.php') ?>">Create account</a>
    </div>
  </div>

  <section class="section">
    <h2>Our mission</h2>
    
      
       <main class="container">
    <section class="hero">
      <div class="col">
        <p>SurexGate is a mini-bank application designed to provide users with a secure, streamlined platform for managing financial transactions in a business-oriented environment. While it facilitates account management, balance tracking, and transaction overview, it is important to note that SurexGate operates as an intermediary platform, and all actual banking services are provided by licensed financial institutions.

The application emphasizes user security and accountability. User credentials are protected using advanced hashing techniques, and while the platform safeguards sensitive data, users are responsible for maintaining the security of their devices. In addition, SurexGate enforces strict guidelines on conduct, prohibiting any form of abuse, unauthorized reverse engineering, or engagement in illegal activity.

Designed with accessibility and efficiency in mind, SurexGate provides a reliable interface for individuals and businesses to monitor and interact with their accounts seamlessly. Its liability framework clearly states that the app is provided is ensuring users understand its scope and limitations, while still delivering a professional, trustworthy digital banking experience.</p>
        <div class="actions">
          <a class="btn" href="<?= url('register.php') ?>">Get started</a>
          <a class="btn ghost" href="/public/faq.php">Learn more</a>
        </div>
      </div><br><br>

  <section class="section">
    <h2>How it works</h2>
    <div class="grid3">
      <div class="card"><h3>Sign up</h3><p class="muted">Create an account in secondsmail + password.</p></div>
      <div class="card"><h3>Fund & Transfer</h3><p class="muted">Top-up (demo) and transfer between users instantly.</p></div>
      <div class="card"><h3>Track activity</h3><p class="muted">See balances, statements, and approvals (if enabled).</p></div>
    </div>
  </section>

<br><br>


<a href="path/to/SurexGate_Whitepaper.pdf" target="_blank" download>
  <img src="whitepaper-thumbnail.jpg" 
       alt="SurexGate Whitepaper Preview" 
       style="width:200px; height:auto; border:1px solid #ccc; border-radius:5px; cursor:pointer;">
</a> <br>
<p>Click the image to view or download the SurexGate Whitepaper.</p>

<br>

  <!-- parara -->
<section class="brand-visual">
  <img
    src="https://whitemanmoney.com/public/assets/images/SurexGate_about.jpeg"
    srcset="https://whitemanmoney.com/public/assets/images/SurexGate_about.jpeg 480w,
            https://whitemanmoney.com/public/assets/images/SurexGate_about.jpeg 768w,
            https://whitemanmoney.com/public/assets/images/SurexGate_about.jpeg 1024w"
    sizes="(max-width: 600px) 80vw, 420px"
    alt="SURE x GATE logo"
    class="brand-logo"
    width="1016" height="683"  <!-- keeps layout stable -->
</section>

<br>
  <div class="footer">
    <div class="nav" style="padding:0">
      <a href="<?= url('index.php') ?>">Home</a>
      <a href="<?= url('faq.php') ?>">FAQ</a>
      <a href="<?= url('terms.php') ?>">Terms</a>
      <a href="<?= url('about.php') ?>">About</a>
    </div>
  </div>
</div>
<?php require_once __DIR__.'/../includes/footer.php'; ?>
