<?php
if (session_status() !== PHP_SESSION_ACTIVE) session_start();
if (empty($_SESSION['uid'])) return; // only show sidebar for signed-in pages

$current = basename($_SERVER['PHP_SELF']);
$active = function(string $file) use ($current) {
  return $current === $file ? 'active' : '';
};

// tiny avatar initials (FB → F)
function initials($name){
  $parts = preg_split('/\s+/', trim($name));
  $chars = '';
  foreach ($parts as $p) { if ($p !== '') { $chars .= mb_strtoupper(mb_substr($p,0,1)); } }
  return mb_substr($chars, 0, 2);
}
?>
<aside class="d-none d-md-block">
  <div class="card shadow-sm mb-3">
    <div class="card-body d-flex align-items-center">
      <div class="rounded-circle bg-dark text-white d-flex align-items-center justify-content-center me-3" style="width:40px;height:40px;">
        <?= initials($_SESSION['fullname'] ?? 'U') ?>
      </div>
      <div class="small">
        <div class="fw-semibold"><?= htmlspecialchars($_SESSION['fullname'] ?? 'User', ENT_QUOTES,'UTF-8') ?></div>
        <div class="text-muted"><?= htmlspecialchars($_SESSION['email'] ?? '', ENT_QUOTES,'UTF-8') ?></div>
      </div>
    </div>
  </div>

  <div class="list-group">
    <a class="list-group-item list-group-item-action <?= $active('dashboard.php') ?>" href="/minibank/public/dashboard.php">🏠 Dashboard</a>
    <a class="list-group-item list-group-item-action <?= $active('transactions.php') ?>" href="/minibank/public/transactions.php">📄 Transactions</a>
    <a class="list-group-item list-group-item-action <?= $active('settings.php') ?>" href="/minibank/public/settings.php">⚙️ Settings</a>
    <a class="list-group-item list-group-item-action <?= $active('payouts.php') ?>" href="/minibank/public/payouts.php">🏦 Payouts</a>
      <a class="list-group-item list-group-item-action" href="/minibank/public/logout.php">↩️ Logout</a>

  </div>
</aside>
