<?php
declare(strict_types=1);

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require_once __DIR__ . '/config.php'; 

// load PHPMailer classes
require_once __DIR__ . '/PHPMailer/src/PHPMailer.php';
require_once __DIR__ . '/PHPMailer/src/SMTP.php';
require_once __DIR__ . '/PHPMailer/src/Exception.php';

function send_mail(string $to, string $subject, string $html, string $text = ''): bool {
    $mail = new PHPMailer(true);
    try {
        if (defined('SMTP_ENABLED') && SMTP_ENABLED) {
            $mail->isSMTP();
            $mail->Host       = SMTP_HOST;
            $mail->SMTPAuth   = true;
            $mail->Username   = SMTP_USER;
            $mail->Password   = SMTP_PASS;
            $mail->SMTPSecure = SMTP_SECURE;  // 'ssl' or 'tls'
            $mail->Port       = SMTP_PORT;    // 465 or 587
        }

        $fromEmail = defined('MAIL_FROM') ? MAIL_FROM : SMTP_USER;
        $fromName  = defined('MAIL_FROM_NAME') ? MAIL_FROM_NAME : 'Whiteman Money';

        $mail->setFrom($fromEmail, $fromName);
        $mail->addAddress($to);

        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body    = $html;
        $mail->AltBody = $text !== '' ? $text : strip_tags($html);

        return $mail->send();
    } catch (Exception $e) {
        // optionally log $mail->ErrorInfo for debugging
        return false;
    }
}
