<?php
// Small helpers we’ll reuse

function sanitize($s) {
  return htmlspecialchars($s ?? '', ENT_QUOTES, 'UTF-8');
}

// Generate a unique 10-digit account number
function generate_account_number(PDO $pdo): string {
  while (true) {
    $acct = str_pad((string)random_int(0, 9999999999), 10, '0', STR_PAD_LEFT);
    $st = $pdo->prepare("SELECT 1 FROM users WHERE account_number = :a LIMIT 1");
    $st->execute([':a' => $acct]);
    if (!$st->fetch()) return $acct;
  }
}
function flash_ok(string $msg){ $_SESSION['flash_ok'] = $msg; }
function flash_err(string $msg){ $_SESSION['flash_err'] = $msg; }

function gen_card_number(): string {
  // Simple demo number: starts 4242 + random; not real Luhn – fine for demo
  $digits = '4242';
  for ($i=0; $i<12; $i++) { $digits .= random_int(0,9); }
  // Format #### #### #### ####
  return substr($digits,0,4).' '.substr($digits,4,4).' '.substr($digits,8,4).' '.substr($digits,12,4);
}
function gen_cvv(): string {
  return str_pad((string)random_int(0,999), 3, '0', STR_PAD_LEFT);
}
function gen_expiry_month(): int { return random_int(1,12); }
function gen_expiry_year(): int {
  $y = (int)date('Y'); 
  return random_int($y+2, $y+5);  // 2–5 years ahead
}
function mask_full(string $s): string {
  // Replace all digits with *
  return preg_replace('/\d/', '*', $s);
}