<?php
declare(strict_types=1);

// ---------- Detect environment ----------
$host    = $_SERVER['HTTP_HOST'] ?? 'localhost';
$isLocal = in_array($host, ['localhost','127.0.0.1']) || str_contains($host, '.local');
$APP_ENV = $isLocal ? 'local' : 'production';

// ---------- Base URL (FIX: add /public on live) ----------
$BASE_URL_LOCAL = 'http://localhost/minibank/public';
$BASE_URL_PROD  = 'https://whitemanmoney.com/public'; // << changed

define('BASE_URL', $isLocal ? $BASE_URL_LOCAL : $BASE_URL_PROD);

// Tiny helper: use this for ALL links/redirects
if (!function_exists('url')) {
  function url(string $path): string {
    return rtrim(BASE_URL, '/') . '/' . ltrim($path, '/');
  }
}

// ---------- Database (use your real creds) ----------
if ($isLocal) {
  define('DB_HOST','127.0.0.1');
  define('DB_NAME','loyaqono_sonia');
  define('DB_USER','loyaqono_sonia_user');
  define('DB_PASS','Fantom25@@');
} else {
  define('DB_HOST','localhost'); // 127.0.0.1 also fine
  define('DB_NAME','loyaqono_sonia');
  define('DB_USER','loyaqono_sonia_user');
  define('DB_PASS','Fantom25@@');
}

// ---------- App toggles ----------
const REQUIRE_TX_APPROVAL = true;
define('APP_DEBUG_VERIFY', $isLocal);
define('APP_DEBUG_EMAIL',  $isLocal);

// ---------- Mail identity ----------
if (!defined('MAIL_FROM'))      define('MAIL_FROM', 'no-reply@whitemanmoney.com');
if (!defined('MAIL_FROM_NAME')) define('MAIL_FROM_NAME', 'MiniBank');
if (!defined('ADMIN_EMAIL'))    define('ADMIN_EMAIL', 'no-reply@whitemanmoney.com');


// ---------- Paystack ----------
$PAYSTACK_TEST_SECRET = 'sk_test_xxxxxxxxxxxxxxxxxxxxxxxxx';
$PAYSTACK_LIVE_SECRET = 'sk_live_xxxxxxxxxxxxxxxxxxxxxxxxx';
define('PAYSTACK_SECRET', $isLocal ? $PAYSTACK_TEST_SECRET : $PAYSTACK_LIVE_SECRET);

define('PAYSTACK_WEBHOOK_URL', url('webhooks/paystack.php'));
define('PAYSTACK_CALLBACK_URL', url('payment/callback.php'));

date_default_timezone_set('Africa/Lagos');

// ---------- SMTP ----------

define('SMTP_ENABLED', true);
define('SMTP_HOST', 'mail.whitemanmoney.com');   // check cPanel for exact hostname
define('SMTP_PORT', 465);                        // usually 465 (SSL) or 587 (TLS)
define('SMTP_SECURE', 'ssl');                    // 'ssl' for 465, 'tls' for 587
define('SMTP_USER', 'no-reply@whitemanmoney.com'); // full mailbox
define('SMTP_PASS', 'Fantom25@@');             // mailbox password






