<?php
// includes/auth.php
if (session_status() === PHP_SESSION_NONE) {
  session_start();
}

if (!function_exists('require_login')) {
  function require_login(): void {
    if (empty($_SESSION['uid'])) {
      header('Location: /minibank/public/login.php');
      exit;
    }
  }
}

if (!function_exists('require_admin')) {
  function require_admin(): void {
    require_login();
    if (empty($_SESSION['is_admin']) || (int)$_SESSION['is_admin'] !== 1) {
      http_response_code(403);
      exit('Admins only.');
    }
  }
}
