<?php
require_once __DIR__ . '/../includes/bootstrap.php';
auth_require_admin();
$uid = (int)($_GET['uid'] ?? $_POST['uid'] ?? 0);
$docs = $pdo->prepare("SELECT id, doc_type FROM kyc_documents WHERE user_id=?");
$docs->execute([$uid]);
foreach ($docs as $d){
  echo "<div>{$d['doc_type']} - <a href='/admin/kyc_file.php?id={$d['id']}'>Open</a></div>";
}
?>
<form method="post">
  <input type="hidden" name="uid" value="<?=$uid?>">
  <button name="action" value="approve">Approve</button>
  <input name="reason" placeholder="Reason if reject">
  <button name="action" value="reject">Reject</button>
</form>
<?php
if ($_SERVER['REQUEST_METHOD']==='POST'){
  if ($_POST['action']==='approve'){
    $pdo->prepare("UPDATE users SET kyc_status='approved', kyc_verified_at=NOW(), kyc_reviewer_id=? WHERE id=?")
        ->execute([$_SESSION['uid'], $uid]);
  } else {
    $reason = trim($_POST['reason'] ?? 'Unclear/invalid');
    $pdo->prepare("UPDATE users SET kyc_status='rejected', kyc_reject_reason=?, kyc_reviewer_id=?, kyc_verified_at=NULL WHERE id=?")
        ->execute([$reason, $_SESSION['uid'], $uid]);
  }
  header("Location: /admin/kyc_queue.php");
}
