<?php
// /admin/index.php
declare(strict_types=1);
session_start();

require_once __DIR__ . '/../includes/bootstrap.php'; // must set $pdo and helpers
auth_require_admin();

// Quick stats (keep fast)
$stats = [];
$stats['users_total']      = (int)$pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();
$stats['users_pendingKYC'] = (int)$pdo->query("SELECT COUNT(*) FROM users WHERE kyc_status='pending'")->fetchColumn();
$stats['tx_total']         = (int)$pdo->query("SELECT COUNT(*) FROM transactions")->fetchColumn();
$stats['tx_today']         = (int)$pdo->query("SELECT COUNT(*) FROM transactions WHERE DATE(created_at)=CURDATE()")->fetchColumn();

// Recent pending KYC (top 5)
$pending = $pdo->query("
  SELECT id, email, kyc_submitted_at
  FROM users
  WHERE kyc_status='pending'
  ORDER BY kyc_submitted_at ASC
  LIMIT 5
")->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Admin • Dashboard</title>
<style>
  :root{
    --bg:#0b0f17; --panel:#101826; --ink:#e6edf6; --muted:#a3b1c6;
    --brand:#4f8cff; --ok:#06d6a0; --warn:#ffd166; --danger:#ef476f; --border:#1d2636;
  }
  *{box-sizing:border-box} body{margin:0;background:var(--bg);color:var(--ink);font:15.5px/1.55 Inter,system-ui,-apple-system,Segoe UI,Roboto}
  a{color:inherit;text-decoration:none}
  .wrap{display:grid;grid-template-columns:240px 1fr;min-height:100vh}
  .side{background:#0e1522;border-right:1px solid var(--border);padding:18px 14px;position:sticky;top:0;height:100vh}
  .side h1{font-size:18px;margin:0 0 16px;font-weight:700;color:var(--brand)}
  .nav a{display:flex;align-items:center;gap:10px;padding:10px 12px;border-radius:10px;color:var(--muted)}
  .nav a:hover{background:rgba(79,140,255,0.08);color:var(--ink)}
  .main{padding:22px;max-width:1100px;margin:0 auto}
  .grid{display:grid;grid-template-columns:repeat(4,minmax(0,1fr));gap:14px}
  .card{background:var(--panel);border:1px solid var(--border);border-radius:14px;padding:16px}
  .kpi h3{margin:0 0 6px;font-size:13px;color:var(--muted)}
  .kpi .num{font-size:28px;font-weight:800}
  .table{width:100%;border-collapse:collapse}
  .table th,.table td{padding:10px;border-bottom:1px solid var(--border);text-align:left;font-size:14px}
  .badge{display:inline-block;padding:.18rem .5rem;border-radius:.5rem;font-weight:600;font-size:12px;border:1px solid transparent}
  .badge-ok{color:var(--ok);background:color-mix(in srgb, var(--ok) 15%, transparent);border-color:color-mix(in srgb, var(--ok) 35%, transparent)}
  .badge-warn{color:var(--warn);background:color-mix(in srgb, var(--warn) 15%, transparent);border-color:color-mix(in srgb, var(--warn) 35%, transparent)}
  .btn{display:inline-block;background:var(--brand);color:#fff;padding:8px 12px;border-radius:10px;font-weight:600}
  .btn.sec{background:#1a2435;color:var(--ink);border:1px solid var(--border)}
  @media (max-width:960px){.grid{grid-template-columns:repeat(2,minmax(0,1fr))}}
  @media (max-width:640px){.wrap{grid-template-columns:1fr}.side{position:static;height:auto}.grid{grid-template-columns:1fr}}
</style>
</head>
<body>
<div class="wrap">
  <aside class="side">
    <h1>Admin Panel</h1>
    <nav class="nav">
      <a href="/admin/index.php">🏠 Dashboard</a>
      <a href="/admin/kyc_queue.php">🪪 KYC Requests
        <?php if($stats['users_pendingKYC']>0): ?>
          <span class="badge badge-warn" style="margin-left:auto"><?= $stats['users_pendingKYC'] ?></span>
        <?php endif; ?>
      </a>
      <a href="/admin/users.php">👤 Users</a>
      <a href="/admin/transactions.php">💸 Transactions</a>
      <a href="/public/dashboard.php">↩ Back to App</a>
      <a href="/public/logout.php">🚪 Logout</a>
    </nav>
  </aside>

  <main class="main">
    <h2 style="margin:0 0 14px">Dashboard overview</h2>

    <section class="grid">
      <div class="card kpi"><h3>Total users</h3><div class="num"><?= $stats['users_total'] ?></div></div>
      <div class="card kpi"><h3>Pending KYC</h3><div class="num"><?= $stats['users_pendingKYC'] ?></div></div>
      <div class="card kpi"><h3>Transactions (all)</h3><div class="num"><?= $stats['tx_total'] ?></div></div>
      <div class="card kpi"><h3>Transactions (today)</h3><div class="num"><?= $stats['tx_today'] ?></div></div>
    </section>

    <section class="card" style="margin-top:16px">
      <div style="display:flex;align-items:center;justify-content:space-between;margin-bottom:10px">
        <h3 style="margin:0">Pending KYC (top 5)</h3>
        <a class="btn sec" href="/admin/kyc_queue.php">Open queue</a>
      </div>
      <table class="table">
        <thead><tr><th>User</th><th>Submitted at</th><th>Action</th></tr></thead>
        <tbody>
          <?php if(!$pending): ?>
            <tr><td colspan="3" style="color:var(--muted)">No pending KYC 🎉</td></tr>
          <?php else: foreach($pending as $r): ?>
            <tr>
              <td><?= htmlspecialchars($r['email']) ?></td>
              <td><?= htmlspecialchars($r['kyc_submitted_at']) ?></td>
              <td><a class="btn" href="/admin/kyc_review.php?uid=<?= (int)$r['id'] ?>">Review</a></td>
            </tr>
          <?php endforeach; endif; ?>
        </tbody>
      </table>
    </section>

    <section class="card" style="margin-top:16px">
      <h3 style="margin:0 0 8px">Quick links</h3>
      <div style="display:flex;gap:10px;flex-wrap:wrap">
        <a class="btn" href="/admin/users.php">Manage users</a>
        <a class="btn" href="/admin/transactions.php">View transactions</a>
        <a class="btn" href="/admin/kyc_queue.php">Process KYC</a>
      </div>
    </section>
  </main>
</div>
</body>
</html>
